/****** Object:  StoredProcedure [dbo].[usp_Filter_Updating_Patients]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Filter_Updating_Patients]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Filter_Updating_Patients]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

--
-- =============================================
-- Author		:	PII
-- Created date	:	08/27/2012
-- Description	:	Gets updating patients.
-- =============================================
-- =============================================
-- Update by:	PII
-- Update date: 26.10.2012
-- Description:	Separated events from acts. 
-- =============================================

CREATE PROCEDURE [dbo].[usp_Filter_Updating_Patients] 
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@DOMAIN_ID VARCHAR(50)
AS
BEGIN
	SET NOCOUNT ON;	
	
	SELECT DISTINCT P.PATIENT_UID AS UID
	FROM
		(SELECT PATIENT_UID
		FROM ADMISSION_EVN
			WHERE HAS_DISCHARGE = 0 AND VISTA_SITE_UID = @VISTA_SITE_UID
		UNION
		SELECT A.PATIENT_UID
		FROM ACT AS A
			INNER JOIN WAITING_LIST AS WL ON A.ID = WL.ACT_ID	
		WHERE WL.VISTA_SITE_UID = @VISTA_SITE_UID AND WL.REMOVED_DATE IS NULL
		UNION 
		SELECT A.PATIENT_UID
		FROM ACT AS A
			INNER JOIN TRANSFER_REQ AS TR ON A.ID = TR.ACT_ID
			LEFT JOIN ACT AS AEVN ON AEVN.PARENT_ACT_ID = TR.ACT_ID
			LEFT JOIN TRANSFER_EVN AS TE ON TE.ACT_ID = AEVN.ID
		WHERE TR.VISTA_SITE_UID = @VISTA_SITE_UID AND TE.ACT_ID IS NULL ) AS P

END
GO

